## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-dic-fit-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Data input options' and 'Fitting options' boxes in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-dicentrics-fit-01.png")

## ----sc-dic-fit-03, echo=FALSE, out.width='75%', fig.align='center', fig.cap="'Data input' box in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-dicentrics-fit-03.png")

## ----dic-count-data, tidy=TRUE, tidy.opts=list(width.cutoff=60)---------------
count_data <- system.file("extdata", "count-data-barquinero-1995.csv", package = "biodosetools") %>%
  utils::read.csv() %>%
  calculate_aberr_table(type = "count")

## -----------------------------------------------------------------------------
count_data

## ----sc-dic-fit-02, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Irradiation conditions' box in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-dicentrics-fit-02.png")

## ----sc-dic-fit-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Export results' boxes in the dose-effect fitting module"----
knitr::include_graphics("figures/screenshot-dicentrics-fit-04.png")

## ----dic-fit-results----------------------------------------------------------
fit_results <- fit(
  count_data = count_data,
  model_formula = "lin-quad",
  model_family = "automatic",
  fit_link = "identity",
  aberr_module = "dicentrics"
)

## -----------------------------------------------------------------------------
names(fit_results)

## ----dic-fit-coeffs-r---------------------------------------------------------
fit_results$fit_coeffs

## ----dic-fit-dose-curve, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plot of dose-effect curve generated by \\{biodosetools\\}. The grey shading indicates the uncertainties associated with the calibration curve."----
plot_fit_dose_curve(
  fit_results,
  aberr_name = "Dicentrics",
  place = "UI"
)

