/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.gif.GIFEncoder;
import org.freehep.graphicsio.gif.GIFImageWriteParam;
import org.freehep.graphicsio.gif.GIFImageWriterSpi;

public class GIFImageWriter
extends ImageWriter {
    public GIFImageWriter(GIFImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException("output was not set");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        ImageOutputStream ios = (ImageOutputStream)output;
        RenderedImage ri = image.getRenderedImage();
        if (!(ri instanceof BufferedImage)) {
            throw new IOException("Image not of type BufferedImage");
        }
        BufferedImage bi = (BufferedImage)ri;
        boolean interlaced = param.getProgressiveMode() != 0;
        GIFEncoder encoder = new GIFEncoder((Image)bi, (DataOutput)ios, interlaced);
        encoder.encode();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new GIFImageWriteParam(this.getLocale());
    }
}

